/*************************************************************************
*
* Freescale Confidential Proprietary
*
* Copyright (c) 2012-2013 Freescale Semiconductor;
* All Rights Reserved
*
**************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************/

#include "tiny_ui_hal.h"
#include "tiny_ui_kernel.h"
#include "tiny_ui_platform.h"
#include "tiny_ui_raw.h"



/*** imports *****************************************************************/

extern char __CONTRAM_start[];
extern char __CONTRAM_start_GPU[];
extern char __CONTRAM_end[];


/*** macros/consts ***********************************************************/

#define	ERR_EXIT	for(;;);

/*** types *******************************************************************/

/*** local functions *********************************************************/

void	gc_isr(void);

/*** local data **************************************************************/

static volatile uint32_t gpuSyncEvent = 0;
tiny_ui_platform_init_t platform_cfg = {.sleep_func = NULL, .event_func = NULL, .int_install_func = NULL};
int8_t cpuMemPoolId = -1;
int8_t gpuMemPoolId = -1;

/*****************************************************************************/

/*********************
* Platform functions *
*********************/

void tiny_ui_platform_init(tiny_ui_platform_init_t * init_struct)
{
	if (init_struct != NULL)
	{
		platform_cfg = * init_struct;
	}
	
	cpuMemPoolId = memory_pool_create((uint32_t)__CONTRAM_start, (uint32_t)__CONTRAM_start_GPU);
	gpuMemPoolId = memory_pool_create((uint32_t)__CONTRAM_start_GPU, (uint32_t)__CONTRAM_end);
}

void tiny_ui_platform_close(void)
{
	memory_pool_destroy_all();
}

/*****************************************************************************/

void * tiny_ui_hal_alloc(unsigned long size)
{
	return memory_pool_allocate(cpuMemPoolId, size, -1);
} 

/*****************************************************************************/

void tiny_ui_hal_free(void * memory)
{
	memory_pool_free(cpuMemPoolId, memory);
} // tiny_ui_hal_wait_interrupt()

/*****************************************************************************/

void tiny_ui_hal_delay(uint32_t milliseconds)
{
	if (platform_cfg.sleep_func != NULL)
	{
		platform_cfg.sleep_func(milliseconds);
	}
} 	// tiny_ui_hal_wait_interrupt()

/*****************************************************************************/

void tiny_ui_hal_initialize(void)
{
	init_vybrid_twr_hw();
	
	if (platform_cfg.int_install_func != NULL)
	{
		platform_cfg.int_install_func(INT_GC355, gc_isr);
	}
} // tiny_ui_hal_initialize()

/*****************************************************************************/

void tiny_ui_hal_deinitialize(void)
{
} // tiny_ui_hal_deinitialize()

/*****************************************************************************/

void * tiny_ui_hal_allocate_contiguous(unsigned long size, void ** logical, uint32_t * physical)
{
	* logical = memory_pool_allocate(gpuMemPoolId, size, 0x40);
	*physical	= (unsigned int)*logical;

	return (*logical);
} // tiny_ui_hal_allocate_contiguous()

/*****************************************************************************/

void tiny_ui_hal_free_contiguous(void * memory_handle)
{
	memory_pool_free(gpuMemPoolId, memory_handle);
} // tiny_ui_hal_free_contiguous()

/*****************************************************************************/

void * tiny_ui_hal_map(unsigned long size, void * logical, uint32_t physical, uint32_t * gpu)
{
	* gpu = physical;
	return ((void *)physical);

} // tiny_ui_hal_map()

/*****************************************************************************/

void tiny_ui_hal_unmap(void * handle)
{
} // tiny_ui_hal_unmap()

/*****************************************************************************/

void tiny_ui_hal_barrier(void)
{
	//raw_cache_flush();
        //_a5_dcache_flush();
} // tiny_ui_hal_barrier()

/*****************************************************************************/

uint32_t tiny_ui_hal_peek(uint32_t address)
{
	return dec_peek(address);
} // tiny_ui_hal_peek()

/*****************************************************************************/

void tiny_ui_hal_poke(uint32_t address, uint32_t data)
{
	dec_poke(address, data);
} // tiny_ui_hal_poke()

/*****************************************************************************/

int32_t tiny_ui_hal_wait_interrupt(uint32_t timeout)
{
	if (platform_cfg.event_func != NULL)
	{
		platform_cfg.event_func(&gpuSyncEvent);
	}
	
	tiny_ui_hal_peek(0x00010);
	gpuSyncEvent = 0;

	
	return 1;
} 	// tiny_ui_hal_wait_interrupt()

/*****************************************************************************/
/*****************************************************************************/

/*****************************************************************************/

void gc_isr(void)
{
	tiny_ui_hal_peek(0x00010);
	gpuSyncEvent = 1;
} // gc_Isr()
